DROP INDEX CIS.CIS_VLDTN_STATUS_TYPE_UK_I;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_STATUS_TYPE_UK_I ON CIS.CIS_VLDTN_STATUS_TYPE
(VLDTN_STATUS_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_STATUS_TYPE_PK;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_STATUS_TYPE_PK ON CIS.CIS_VLDTN_STATUS_TYPE
(CIS_VLDTN_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_STATUS_TYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_STATUS_TYPE_H_PK ON CIS.CIS_VLDTN_STATUS_TYPE_H
(CIS_VLDTN_STATUS_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_RSLT_PK;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_RSLT_PK ON CIS.CIS_VLDTN_RSLT
(CIS_VLDTN_RSLT_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_RSLT_H_PK;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_RSLT_H_PK ON CIS.CIS_VLDTN_RSLT_H
(CIS_VLDTN_RSLT_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_RSLT_CLOB_PFK;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_RSLT_CLOB_PFK ON CIS.CIS_VLDTN_RSLT_CLOB
(CIS_VLDTN_RSLT_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_RSLT_CLOB_H_PK;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_RSLT_CLOB_H_PK ON CIS.CIS_VLDTN_RSLT_CLOB_H
(CIS_VLDTN_RSLT_CLOB_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_PRBLM_TY_PRBLM_FK_I;

CREATE INDEX CIS.CIS_VLDTN_PRBLM_TY_PRBLM_FK_I ON CIS.CIS_VLDTN_PRBLM
(CIS_VLDTN_PRBLM_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_PRBLM_TYPE_UK_I;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_PRBLM_TYPE_UK_I ON CIS.CIS_VLDTN_PRBLM_TYPE
(VLDTN_PRBLM_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_PRBLM_TYPE_PK;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_PRBLM_TYPE_PK ON CIS.CIS_VLDTN_PRBLM_TYPE
(CIS_VLDTN_PRBLM_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_PRBLM_TYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_PRBLM_TYPE_H_PK ON CIS.CIS_VLDTN_PRBLM_TYPE_H
(CIS_VLDTN_PRBLM_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_PRBLM_PK;

CREATE INDEX CIS.CIS_VLDTN_PRBLM_PK ON CIS.CIS_VLDTN_PRBLM
(CIS_VLDTN_PRBLM_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTN_PRBLM_H_PK;

CREATE INDEX CIS.CIS_VLDTN_PRBLM_H_PK ON CIS.CIS_VLDTN_PRBLM_H
(CIS_VLDTN_PRBLM_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTNST_RSLT_CRCTDST_FK_I;

CREATE INDEX CIS.CIS_VLDTNST_RSLT_CRCTDST_FK_I ON CIS.CIS_VLDTN_RSLT
(CRCTD_STTS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTNSTTS_RSLT_DLYPNT_FK_I;

CREATE INDEX CIS.CIS_VLDTNSTTS_RSLT_DLYPNT_FK_I ON CIS.CIS_VLDTN_RSLT
(CRCTD_DLVRY_PNT_VLDTN_STTS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_VLDTNRSLT_VLDTNPRBLM_FK_I;

CREATE INDEX CIS.CIS_VLDTNRSLT_VLDTNPRBLM_FK_I ON CIS.CIS_VLDTN_PRBLM
(CIS_VLDTN_RSLT_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_STATTYPE_PK;

CREATE UNIQUE INDEX CIS.CIS_STATTYPE_PK ON CIS.CIS_STAT_TYPE
(CIS_STAT_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_STATTYPE_INFORULESTAT_FK_I;

CREATE INDEX CIS.CIS_STATTYPE_INFORULESTAT_FK_I ON CIS.CIS_CONT_INFO_RULE_STATUS
(CIS_STAT_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_STATTYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_STATTYPE_H_PK ON CIS.CIS_STAT_TYPE_H
(CIS_STAT_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_STATTYPE_CISINTSTAT_FK_I;

CREATE INDEX CIS.CIS_STATTYPE_CISINTSTAT_FK_I ON CIS.CIS_CONT_INFO_STATUS
(CIS_INT_STAT_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_STATTYPE_CISEXTSTAT_FK_I;

CREATE INDEX CIS.CIS_STATTYPE_CISEXTSTAT_FK_I ON CIS.CIS_CONT_INFO_STATUS
(CIS_EXT_STAT_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_STATTYPE_CD_UK;

CREATE UNIQUE INDEX CIS.CIS_STATTYPE_CD_UK ON CIS.CIS_STAT_TYPE
(STAT_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_RULETYPE_PK;

CREATE UNIQUE INDEX CIS.CIS_RULETYPE_PK ON CIS.CIS_RULE_TYPE
(CIS_RULE_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_RULETYPE_INFORULESTAT_FK_I;

CREATE INDEX CIS.CIS_RULETYPE_INFORULESTAT_FK_I ON CIS.CIS_CONT_INFO_RULE_STATUS
(CIS_RULE_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_RULETYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_RULETYPE_H_PK ON CIS.CIS_RULE_TYPE_H
(CIS_RULE_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_RULETYPE_CD_UK;

CREATE UNIQUE INDEX CIS.CIS_RULETYPE_CD_UK ON CIS.CIS_RULE_TYPE
(RULE_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PURPTYP_CONTINFOPRPS_FK_I;

CREATE INDEX CIS.CIS_PURPTYP_CONTINFOPRPS_FK_I ON CIS.CIS_CONT_INFO_PURPOSE
(CIS_PURP_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PURPOSEYPE_CD_UK;

CREATE UNIQUE INDEX CIS.CIS_PURPOSEYPE_CD_UK ON CIS.CIS_PURPOSE_TYPE
(PURP_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PURPOSETYPE_PK;

CREATE UNIQUE INDEX CIS.CIS_PURPOSETYPE_PK ON CIS.CIS_PURPOSE_TYPE
(CIS_PURP_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PURPOSETYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_PURPOSETYPE_H_PK ON CIS.CIS_PURPOSE_TYPE_H
(CIS_PURP_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PRVNC_ADDR_TYPE_FK_I;

CREATE INDEX CIS.CIS_PRVNC_ADDR_TYPE_FK_I ON CIS.CIS_ADDRESS_TYPE
(CIS_PROVENANCE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PRTYSRCIDTY_PRTYINFO_FK_I;

CREATE INDEX CIS.CIS_PRTYSRCIDTY_PRTYINFO_FK_I ON CIS.CIS_PARTY_INFO
(CIS_PARTY_SRC_ID_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PRPS_TYPE_PRPS_FK_I;

CREATE INDEX CIS.CIS_PRPS_TYPE_PRPS_FK_I ON CIS.CIS_CONT_INFO_TYPE_PRPS
(CIS_PURP_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PROVENANCE_PK;

CREATE UNIQUE INDEX CIS.CIS_PROVENANCE_PK ON CIS.CIS_PROVENANCE
(CIS_PROVENANCE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PREFTYPE_INFOPREF_FK_I;

CREATE INDEX CIS.CIS_PREFTYPE_INFOPREF_FK_I ON CIS.CIS_CONT_INFO_PREF
(CIS_PREF_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PREFTYPE_CD_UK;

CREATE UNIQUE INDEX CIS.CIS_PREFTYPE_CD_UK ON CIS.CIS_PREF_TYPE
(PREF_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PREFTYPECD_PK;

CREATE UNIQUE INDEX CIS.CIS_PREFTYPECD_PK ON CIS.CIS_PREF_TYPE
(CIS_PREF_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PREFTYPECD_H_PK;

CREATE UNIQUE INDEX CIS.CIS_PREFTYPECD_H_PK ON CIS.CIS_PREF_TYPE_H
(CIS_PREF_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PHONETYPE_PK;

CREATE UNIQUE INDEX CIS.CIS_PHONETYPE_PK ON CIS.CIS_PHONE_TYPE
(CIS_PHONE_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PHONETYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_PHONETYPE_H_PK ON CIS.CIS_PHONE_TYPE_H
(CIS_PHONE_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PHONETYPE_CONTINFOPH_FK_I;

CREATE INDEX CIS.CIS_PHONETYPE_CONTINFOPH_FK_I ON CIS.CIS_CONT_INFO_PHONE
(CIS_PHONE_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PHONETYPE_CD_UK;

CREATE UNIQUE INDEX CIS.CIS_PHONETYPE_CD_UK ON CIS.CIS_PHONE_TYPE
(PHONE_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTY_SRCID_TYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_PARTY_SRCID_TYPE_H_PK ON CIS.CIS_PARTY_SRC_ID_TYPE_H
(CIS_PARTY_SRC_ID_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTY_RLNTTYP_RLNSHP_FK_I;

CREATE INDEX CIS.CIS_PARTY_RLNTTYP_RLNSHP_FK_I ON CIS.CIS_PARTY_RLNSHP
(CIS_PARTY_RLNSHP_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTY_PRVNNCE_CRTR_FK_I;

CREATE INDEX CIS.CIS_PARTY_PRVNNCE_CRTR_FK_I ON CIS.CIS_PROVENANCE
(REC_CRTR_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTY_PRVNNCE_APLCTN_FK_I;

CREATE INDEX CIS.CIS_PARTY_PRVNNCE_APLCTN_FK_I ON CIS.CIS_PROVENANCE
(SRC_APLCTN_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTY_PK;

CREATE UNIQUE INDEX CIS.CIS_PARTY_PK ON CIS.CIS_PARTY
(CIS_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTY_PARTYRLNSHPSEC_FK_I;

CREATE INDEX CIS.CIS_PARTY_PARTYRLNSHPSEC_FK_I ON CIS.CIS_PARTY_RLNSHP
(CIS_SEC_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTY_PARTYRLNSHPPRI_FK_I;

CREATE INDEX CIS.CIS_PARTY_PARTYRLNSHPPRI_FK_I ON CIS.CIS_PARTY_RLNSHP
(CIS_PRI_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTY_PARTYHISTORY_FK_I;

CREATE INDEX CIS.CIS_PARTY_PARTYHISTORY_FK_I ON CIS.CIS_PARTY_INFO
(CIS_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTY_INFO_H_PK;

CREATE UNIQUE INDEX CIS.CIS_PARTY_INFO_H_PK ON CIS.CIS_PARTY_INFO_H
(CIS_PARTY_INFO_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTY_CONTINFOPROF_FK_I;

CREATE INDEX CIS.CIS_PARTY_CONTINFOPROF_FK_I ON CIS.CIS_CONT_INFO_PROF
(CIS_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYSRCIDTYPE_PK;

CREATE UNIQUE INDEX CIS.CIS_PARTYSRCIDTYPE_PK ON CIS.CIS_PARTY_SRC_ID_TYPE
(CIS_PARTY_SRC_ID_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYSRCIDTYPE_CD_UK;

CREATE UNIQUE INDEX CIS.CIS_PARTYSRCIDTYPE_CD_UK ON CIS.CIS_PARTY_SRC_ID_TYPE
(PARTY_SRC_ID_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYRLNSHP_UK;

CREATE UNIQUE INDEX CIS.CIS_PARTYRLNSHP_UK ON CIS.CIS_PARTY_RLNSHP
(CIS_PRI_PARTY_ID, CIS_SEC_PARTY_ID, CIS_PARTY_RLNSHP_TYPE_ID, EFCTV_START_DT)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYRLNSHP_PK;

CREATE UNIQUE INDEX CIS.CIS_PARTYRLNSHP_PK ON CIS.CIS_PARTY_RLNSHP
(CIS_PARTY_RLNSHP_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYRLNSHP_CONTINFO_FK_I;

CREATE INDEX CIS.CIS_PARTYRLNSHP_CONTINFO_FK_I ON CIS.CIS_CONT_INFO
(CIS_PARTY_RLNSHP_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYRLNSHPTYPE_PK;

CREATE UNIQUE INDEX CIS.CIS_PARTYRLNSHPTYPE_PK ON CIS.CIS_PARTY_RLNSHP_TYPE
(CIS_PARTY_RLNSHP_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYRLNSHPTYPE_CD_UK;

CREATE UNIQUE INDEX CIS.CIS_PARTYRLNSHPTYPE_CD_UK ON CIS.CIS_PARTY_RLNSHP_TYPE
(PARTY_RLNSHP_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYRELSHP_H_PK;

CREATE UNIQUE INDEX CIS.CIS_PARTYRELSHP_H_PK ON CIS.CIS_PARTY_RLNSHP_H
(CIS_PARTY_RLNSHP_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYRELATEDTYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_PARTYRELATEDTYPE_H_PK ON CIS.CIS_PARTY_RLNSHP_TYPE_H
(CIS_PARTY_RLNSHP_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYINFO_UK;

CREATE UNIQUE INDEX CIS.CIS_PARTYINFO_UK ON CIS.CIS_PARTY_INFO
(CIS_PARTY_SRC_ID_TYPE_ID, CIS_PARTY_ID, EFCTV_START_DT)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYINFO_PK;

CREATE UNIQUE INDEX CIS.CIS_PARTYINFO_PK ON CIS.CIS_PARTY_INFO
(CIS_PARTY_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_PARTYINFO_CONTINFO_FK_I;

CREATE INDEX CIS.CIS_PARTYINFO_CONTINFO_FK_I ON CIS.CIS_CONT_INFO
(SRC_PARTY_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_STTS_TY_DATA_FK_I;

CREATE INDEX CIS.CIS_INFLGHT_STTS_TY_DATA_FK_I ON CIS.CIS_INFLGHT_DATA_STATUS
(CIS_INFLGHT_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_STATUS_TYPE_UK_I;

CREATE UNIQUE INDEX CIS.CIS_INFLGHT_STATUS_TYPE_UK_I ON CIS.CIS_INFLGHT_STATUS_TYPE
(INFLGHT_STATUS_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_STATUS_TYPE_PK;

CREATE UNIQUE INDEX CIS.CIS_INFLGHT_STATUS_TYPE_PK ON CIS.CIS_INFLGHT_STATUS_TYPE
(CIS_INFLGHT_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_STATUS_TYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_INFLGHT_STATUS_TYPE_H_PK ON CIS.CIS_INFLGHT_STATUS_TYPE_H
(CIS_INFLGHT_STATUS_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_STATUS_DATA_FK_I;

CREATE INDEX CIS.CIS_INFLGHT_STATUS_DATA_FK_I ON CIS.CIS_INFLGHT_DATA
(CIS_INFLGHT_DATA_STATUS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_DATA_STATUS_PK;

CREATE UNIQUE INDEX CIS.CIS_INFLGHT_DATA_STATUS_PK ON CIS.CIS_INFLGHT_DATA_STATUS
(CIS_INFLGHT_DATA_STATUS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_DATA_STATUS_H_PK;

CREATE UNIQUE INDEX CIS.CIS_INFLGHT_DATA_STATUS_H_PK ON CIS.CIS_INFLGHT_DATA_STATUS_H
(CIS_INFLGHT_DATA_STATUS_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_DATA_PK;

CREATE INDEX CIS.CIS_INFLGHT_DATA_PK ON CIS.CIS_INFLGHT_DATA
(CIS_INFLGHT_DATA_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_DATA_H_PK;

CREATE INDEX CIS.CIS_INFLGHT_DATA_H_PK ON CIS.CIS_INFLGHT_DATA_H
(CIS_INFLGHT_DATA_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_DATA_CLOB_PFK;

CREATE UNIQUE INDEX CIS.CIS_INFLGHT_DATA_CLOB_PFK ON CIS.CIS_INFLGHT_DATA_CLOB
(CIS_INFLGHT_DATA_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_DATA_CLOB_H_PK;

CREATE UNIQUE INDEX CIS.CIS_INFLGHT_DATA_CLOB_H_PK ON CIS.CIS_INFLGHT_DATA_CLOB_H
(CIS_INFLGHT_DATA_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_INFLGHT_CI_DQ_FK_I;

CREATE INDEX CIS.CIS_INFLGHT_CI_DQ_FK_I ON CIS.CIS_CONT_INFO_DATA_QUALITY
(CIS_INFLGHT_DATA_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_EMAILTYP_CONTINFEMAIL_FK_I;

CREATE INDEX CIS.CIS_EMAILTYP_CONTINFEMAIL_FK_I ON CIS.CIS_CONT_INFO_EMAIL
(CIS_EMAIL_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_EMAILTYPE_PK;

CREATE UNIQUE INDEX CIS.CIS_EMAILTYPE_PK ON CIS.CIS_EMAIL_TYPE
(CIS_EMAIL_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_EMAILTYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_EMAILTYPE_H_PK ON CIS.CIS_EMAIL_TYPE_H
(CIS_EMAIL_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_EMAILTYPE_CD_UK;

CREATE UNIQUE INDEX CIS.CIS_EMAILTYPE_CD_UK ON CIS.CIS_EMAIL_TYPE
(EMAIL_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CT_TYPE_TYPEPRPS_FK_I;

CREATE INDEX CIS.CIS_CT_TYPE_TYPEPRPS_FK_I ON CIS.CIS_CONT_INFO_TYPE_PRPS
(CIS_CONT_INFO_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONT_INFO_TYPE_PRPS_PK;

CREATE UNIQUE INDEX CIS.CIS_CONT_INFO_TYPE_PRPS_PK ON CIS.CIS_CONT_INFO_TYPE_PRPS
(CIS_CONT_INFO_TYPE_PRPS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONT_INFO_TYPE_PRPS_H_PK;

CREATE UNIQUE INDEX CIS.CIS_CONT_INFO_TYPE_PRPS_H_PK ON CIS.CIS_CONT_INFO_TYPE_PRPS_H
(CIS_CONT_INFO_TYPE_PRPS_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONT_INFO_ID_PK;

CREATE UNIQUE INDEX CIS.CIS_CONT_INFO_ID_PK ON CIS.CIS_CONT_INFO
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONT_INFO_H_ID_PK;

CREATE UNIQUE INDEX CIS.CIS_CONT_INFO_H_ID_PK ON CIS.CIS_CONT_INFO_H
(CIS_CONT_INFO_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINF_CONTINFPHONE_FK_I;

CREATE INDEX CIS.CIS_CONTINF_CONTINFPHONE_FK_I ON CIS.CIS_CONT_INFO_PHONE
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINF_CONTINFEMAIL_FK_I;

CREATE INDEX CIS.CIS_CONTINF_CONTINFEMAIL_FK_I ON CIS.CIS_CONT_INFO_EMAIL
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFSTAT_RULESTAT_FK_I;

CREATE INDEX CIS.CIS_CONTINFSTAT_RULESTAT_FK_I ON CIS.CIS_CONT_INFO_RULE_STATUS
(CIS_CONT_INFO_STATUS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFO_PURP_FK_I;

CREATE INDEX CIS.CIS_CONTINFO_PURP_FK_I ON CIS.CIS_CONT_INFO_PURPOSE
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFO_INFOPREF_FK_I;

CREATE INDEX CIS.CIS_CONTINFO_INFOPREF_FK_I ON CIS.CIS_CONT_INFO_PREF
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFO_DATAQUAL_FK_I;

CREATE INDEX CIS.CIS_CONTINFO_DATAQUAL_FK_I ON CIS.CIS_CONT_INFO_DATA_QUALITY
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFO_CONTINFOADDR_FK_I;

CREATE INDEX CIS.CIS_CONTINFO_CONTINFOADDR_FK_I ON CIS.CIS_CONT_INFO_ADDRESS
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOTYP_CONTINFO_FK_I;

CREATE INDEX CIS.CIS_CONTINFOTYP_CONTINFO_FK_I ON CIS.CIS_CONT_INFO
(CIS_CONT_INFO_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOTYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOTYPE_H_PK ON CIS.CIS_CONT_INFO_TYPE_H
(CIS_CONT_INFO_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOTYPE_CD_UK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOTYPE_CD_UK ON CIS.CIS_CONT_INFO_TYPE
(CONT_INFO_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOTYPEID_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOTYPEID_PK ON CIS.CIS_CONT_INFO_TYPE
(CIS_CONT_INFO_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOSTATUS_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOSTATUS_PK ON CIS.CIS_CONT_INFO_STATUS
(CIS_CONT_INFO_STATUS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOSTATUS_H_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOSTATUS_H_PK ON CIS.CIS_CONT_INFO_STATUS_H
(CIS_CONT_INFO_STATUS_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFORULESTATUS_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFORULESTATUS_PK ON CIS.CIS_CONT_INFO_RULE_STATUS
(CIS_CONT_INFO_RULE_STATUS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFORULESTATUS_H_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFORULESTATUS_H_PK ON CIS.CIS_CONT_INFO_RULE_STATUS_H
(CIS_CONT_INFO_RULE_STATUS_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOPURPOSE_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOPURPOSE_PK ON CIS.CIS_CONT_INFO_PURPOSE
(CIS_CONT_INFO_PURPOSE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOPURPOSE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOPURPOSE_H_PK ON CIS.CIS_CONT_INFO_PURPOSE_H
(CIS_CONT_INFO_PURPOSE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOPROF_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOPROF_PK ON CIS.CIS_CONT_INFO_PROF
(CIS_CONT_INFO_PROF_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOPROF_H_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOPROF_H_PK ON CIS.CIS_CONT_INFO_PROF_H
(CIS_CONT_INFO_PROF_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOPROF_CONTINFO_FK_I;

CREATE INDEX CIS.CIS_CONTINFOPROF_CONTINFO_FK_I ON CIS.CIS_CONT_INFO
(CIS_CONT_INFO_PROF_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOPREF_UK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOPREF_UK ON CIS.CIS_CONT_INFO_PREF
(CIS_CONT_INFO_ID, CIS_PREF_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOPREF_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOPREF_PK ON CIS.CIS_CONT_INFO_PREF
(CIS_CONT_INFO_PREF_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOPREF_H_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOPREF_H_PK ON CIS.CIS_CONT_INFO_PREF_H
(CIS_CONT_INFO_PREF_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOPHONE_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOPHONE_PK ON CIS.CIS_CONT_INFO_PHONE
(CIS_CONT_INFO_PHONE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOPHONE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOPHONE_H_PK ON CIS.CIS_CONT_INFO_PHONE_H
(CIS_CONT_INFO_PHONE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOEMAIL_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOEMAIL_PK ON CIS.CIS_CONT_INFO_EMAIL
(CIS_CONT_INFO_EMAIL_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOEMAIL_H_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOEMAIL_H_PK ON CIS.CIS_CONT_INFO_EMAIL_H
(CIS_CONT_INFO_EMAIL_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFODATAQUAL_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFODATAQUAL_PK ON CIS.CIS_CONT_INFO_DATA_QUALITY
(CIS_CONT_INFO_DATA_QUAL_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFODATAQUAL_H_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFODATAQUAL_H_PK ON CIS.CIS_CONT_INFO_DATA_QUALITY_H
(CIS_CONT_INFO_DATA_QUAL_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOADDR_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOADDR_PK ON CIS.CIS_CONT_INFO_ADDRESS
(CIS_CONT_INFO_ADDR_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONTINFOADDR_H_PK;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOADDR_H_PK ON CIS.CIS_CONT_INFO_ADDRESS_H
(CIS_CONT_INFO_ADDR_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CONINFDATQUAL_INFSTAT_FK_I;

CREATE INDEX CIS.CIS_CONINFDATQUAL_INFSTAT_FK_I ON CIS.CIS_CONT_INFO_STATUS
(CIS_CONT_INFO_DATA_QUAL_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_CI_DQ_VLDTN_RSLT_FK_I;

CREATE INDEX CIS.CIS_CI_DQ_VLDTN_RSLT_FK_I ON CIS.CIS_VLDTN_RSLT
(CIS_CONT_INFO_DATA_QUAL_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_ADDRTYPE_PK;

CREATE UNIQUE INDEX CIS.CIS_ADDRTYPE_PK ON CIS.CIS_ADDRESS_TYPE
(CIS_ADDRESS_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_ADDRTYPE_H_PK;

CREATE UNIQUE INDEX CIS.CIS_ADDRTYPE_H_PK ON CIS.CIS_ADDRESS_TYPE_H
(CIS_ADDRESS_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_ADDRTYPE_CONTINFOADDR_FK_I;

CREATE INDEX CIS.CIS_ADDRTYPE_CONTINFOADDR_FK_I ON CIS.CIS_CONT_INFO_ADDRESS
(CIS_ADDRESS_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX CIS.CIS_ADDRTYPE_CD_UK;

CREATE UNIQUE INDEX CIS.CIS_ADDRTYPE_CD_UK ON CIS.CIS_ADDRESS_TYPE
(ADDR_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
